;***********************************;
; WASM Interrupt Access             ;
; By Eric Tauck                     ;
;                                   ;
; Defines:                          ;
;                                   ;
;   IntGet  get an interrupt vector ;
;   IntSet  set an interrupt vector ;
;***********************************;

        jmps    _intr_end

;========================================
; Get an interrupt vector.
;
; In: AL= interrupt number.
;
; Out: DX:BX= vector.

IntGet  PROC    NEAR
        push    es
        mov     ah, 35H         ;get interrupt function
        int     21H             ;execute
        mov     dx, es          ;segment
        pop     es
        ret
        ENDP

;========================================
; Set an interrupt vector.
;
; In: AL= interrupt number; DX:BX=
;     vector.

IntSet  PROC    NEAR
        push    ds
        mov     ah, 25H         ;set interrupt function
        mov     ds, dx          ;segment
        mov     dx, bx          ;offset
        int     21H             ;execute
        pop     ds
        ret
        ENDP

_intr_end
