LANG OCTASM,0.1
define Version 0.17
define ENGLISH 1
define ESPAOL 0
define STRUCT section 15 org 0
define PROCLP(locals,params) pusha enter ->1,0 section 15 org >1->2 # enum 4,locals # rb 40 enum 4,params #RETURNS CODE
define PROCL(locals) pusha enter ->1,0 section 15 org >1->2 # enum 4,locals # CODE
define PROCP(params) pusha section 15 org 36 enum 4,params #RETURNS CODE
define RETURNLP leave popa retp RETURNS-40
define RETURNL leave popa ret
define RETURNP popa retp RETURNS-36
define D()  ##1 rb 4
define W()  ##1 rb 2
define B()  ##1 rb 1
define rm_seg cvar1-2
stack_size=1000h

code org 100h
define CODE section 0
data
section 6 define DAT section 6
section 7 define DAT4 section 7 align 4
section 8 define DAT256 section 8 align 256
virtual
section 11 #start_virtual_data
define VDAT256 section 11 align 256
section 12 define VDAT4 section 12 align 4
section 13 define VDAT section 13
virtual section 15 align 10h #end_virtual_data
dw end_virtual_data+stack_size ;verify there is space for the stack
selector{ org 8 enum 8,code16,code32,data32}
CODE

use16   dx="Octasm %Version $" ah=9 int 21h
	dx="required 486 or better$"
	ax=7202h push ax popf pushf pop bx cmp ax,bx jne error16
	;smsw ax test al,10h jz error16
	cx=end_virtual_data-start_virtual_data
	di=start_virtual_data al=0 rep stosb ;clear uninitialized memory
	di=rm_st+20h stc pushf pop ax stosw
	ax=ds stosw stosw [rm_seg]=ax
	bx=-1 ;allocate maximum conventional memory
     # ah=4ah int 21h jc <1
	dx="no mem$" cmp bx,2000h jc error16
	[rm_seg_size]=bx
	ax=1687h int 2fh test ax jnz >1
	cmp si,1000h ja no_dpmi ;memory for dpmi data
	test bl,1 jnz dpmi ; 32-bit programs supported?
      # smsw ax test al,1 jz real32
#no_dpmi dx="protected mode but no 32bit dmpi$"
#error16 ah=9 int 21h ax=4c03h int 21h

#real32 get_memory()
	eax=cr0 or eax,1 [cr0_pm]=eax
	;init_interrupts
	edi=INTS cx=(IDT_END-IDT_START)/8 si=IDT_START
      # [si]=di w[si+2]=selector\code32
	b[si+5]=8eh si+=8 al=0e8h stosb ;opcode 'call'
	eax=int_xx-4 eax-=edi stosd loop <1
	;set descriptors base adress
	eax=w[rm_seg] shl eax,4 di=GDT_START+10 cl=3
      # or [di],eax add di,8 loop <1
	[GDTR+2]+=eax [IDT_protected_mode+2]+=eax
	protected_mode()
	jmp d start_real32,selector\code32

#free_xms dx=[mem_handle]
	real_mode()
	push dx ah=0dh call far [xms_call] ;unlock
	pop dx ah=0ah call far [xms_call] ;free
	ax=4c00h int 21h    ;exit

#kb_wait cx=0                           ; wait for safe to write to 8042
      # in al,64h test al,2 loopne <1   ; if buffer full loop
	ret

#get_memory
	ax=4300h int 2fh cmp al,80h je xms
	push ds ds=0 lds bx,[4*19h] eax=[bx+12h]
	pop ds cmp eax,'VDIS' jne >1
	ret
      # ax=3D00h dx="EMMXXXX0%0" int 21h jc enable_a20
	ret

#enable_a20 bp=sp
	test_a20()
	in al,92h or al,2 out 92h,al    ; PS/2 A20 enable
	test_a20() kb_wait() jnz test_a20
	al=0D1h out 64h,al kb_wait() jnz test_a20
	al=0DFh out 60h,al kb_wait()
#test_a20
	push ds,es ds=0 es=-1
	al=[0] ah=al not al xchg al,[es+10h]
	ah-=[0] [es+10h]=al
	pop ds,es je >1
	ret
;a20 is enabled and any memory manager detected,so all memory above 1MB can be used
      # sp=bp eax=100000h
	pushad ebx=0
      # eax=0e820h ecx=20 edx='PAMS' di=sp int 15h
	pushfd cmp eax,'PAMS' jne e801h
	popfd jc >3
	dec d[di+16] jnz >2
	ecx=[di+8] eax=[di+28]
	edi=[di] cmp edi,eax jnc >1
	ecx+=edi edi=eax sub ecx,eax jc <1
      # cmp ecx,[memb_size] jna >1  ;get larger block
	[memb_size]=ecx [memb1]=edi
      # test ebx jnz <3
      # popad ret
    #e801h
	eax=0E801h xor ecx,ecx xor edx,edx int 15h jnc >1
	ah=88 int 15h jc >2
	ecx=ax xor edx,edx
      # shl ecx,10 shl edx,16 add ecx,edx
	[memb_size]=ecx d[memb1]=100000h
      # popad ret

#xms    dx="xms $" ah=9 int 21h
	ax=4310h int 2fh [xms_call]=bx [xms_call+2]=es es=ds ;get xms driver address
	ah=3 call far [xms_call] dec ax jnz >2 ;enable gate a20
	ah=88h call far [xms_call] edx=eax ah=89h test bl jz >1 ;eax = size of largest block in KB
	ah=8 call far [xms_call] test bl jnz >2  ;AX = size of largest block in KB
	edx=ax ah=9
      # ebp=edx call far [xms_call] dec ax jnz >1 ;DX = handle for memory block
	[mem_handle]=dx
	ah=0ch call far [xms_call] dec ax jnz >2  ;DX:BX = 32-bit physical address of locked block
	push bx,dx pop edi ecx=bp shl ecx,10
	[memb1]=edi [memb_size]=ecx b[mem_type]=1
      # ret
      # xor dx,dx xchg dx,[mem_handle] ah=0ah call far [xms_call] ret

#Rm_int real_mode() cli pushf push eax,>1,cs
	gs=0 eax=[esp+18] eax=[gs+eax*4]
	xchg eax,[esp] retf
      # sti pushf protected_mode()
	popf db 66h retfp 4

#real_mode
	cli push eax
	lidt d[IDT_real_mode]
	eax=cr0 xchg eax,[cr0_pm] cr0=eax jmp cvar1,0 #cvar1
	ax=[rm_seg] ss=ax ds=ax es=ax fs=ax gs=ax
	pop eax sti ret

#protected_mode
	cli push eax
	lgdt d[GDTR]
	lidt d[IDT_protected_mode]
	eax=cr0 xchg eax,[cr0_pm] cr0=eax jmp >1,selector\code16 #
	ax=selector\data32 ss=ax ds=ax es=ax fs=ax gs=ax
	pop eax sti ret

VDAT4
enum 4,mode_switch,xms_call,cr0_pm,memb1,memb_size
#rm_st rb 20h+9*2
#rm_seg_size rb 2
#mem_handle rb 4
#mem_type rb 1 ; 1=xms 2=dpmi
CODE

#dpmi
	[mode_switch]=di [mode_switch+2]=es sub [rm_seg_size],si
	bx=[rm_seg] add bx,[rm_seg_size] es=bx ;memory for DPMI data
	ax=1 call far [mode_switch] jc no_dpmi
	cx=1 ax=0 int 31h   ; allocate descriptor for code returns ax=selector
	si=ax ax=0 int 31h  ; descriptor for data
	di=ax dx=cs lar cx,dx cl=ch ch=0C0h
	bx=si ax=9 int 31h  ; set code descriptor access rights
	dx=ds lar cx,dx cl=ch ch=0C0h
	bx=di int 31h       ; set data descriptor access rights
	cx=[rm_seg] dx=cx cx>>=12 dx<<=4
	ax=7 int 31h        ; set data descriptor base address
	bx=si int 31h       ; set code descriptor base address
	cx=-1 dx=cx
	ax=8 int 31h        ; set segment limit to 4 GB
	bx=di int 31h ds=di es=di
	push >1,si
	retf
define PN()  pusha prn("%nb %10 #1") eax=#2 prn\n() popa
use32
      # prn("%nb dpmi ") init_dpmi_memory()
#start_real32
	edi=[memb1] eax=w[rm_seg] eax<<=4 sub edi,eax
	eax=[memb_size] test eax jz >1
	mem\add_mem2()  ;extended memory
      # edi=end_virtual_data eax=010000h-stack_size
	sub eax,edi jna >1
	mem\add_mem2() ;conventional memory before the stack
      # edi=10000h eax=w[rm_seg_size] eax<<=4 eax-=edi
	mem\add_mem2() ;conventional memory
	eax=[mem_total] eax>>=10 prn("%nb memory: ") prn\n() prn("%nb KB")
	atob\ini() esi=80h command32()
#exit   dec b[mem_type] jnz >1
	jmp free_xms,selector\code16     ;deallocate xms mem
      # dec b[mem_type] jnz >1
	push [mem_handle] pop si,di ax=502h int 31h ;deallocate dpmi mem
      # al=0 ah=4Ch dos_int()


#prn pusha esi=[esp+arg1]
     ecx=b[esi] inc esi edi=esi
   # al=10 repne scasb jne >1
     pusha ecx=edi-1 sub ecx,esi call >2
     push '%13%10 $' edx=esp ah=9 dos_int() pop eax
     popa esi=edi test cl jnz <1
   # ecx=edi sub ecx,esi call >1 popa retp 4
   # pusha sub esp,256 edi=esp rep movsb
     al='$' stosb edx=esp ah=9 dos_int() add esp,256 popa ret

#init_dpmi_memory
	ax=500h edi=tmp_buffer int 31h ;get free memory information
      # edi=tmp_buffer
	ecx=[edi] ebx=[edi+2]
	shr d[edi],1 cmp ecx,1000h jc >2   ;if allocation fails retry with 1/2
	ax=501h int 31h jc <1   ;allocate
	push si,di pop [mem_handle] b[mem_type]=2
	shl ebx,16 bx=cx eax=[tmp_buffer]
	edi=w[rm_seg] shl edi,4
	neg edi eax+=eax edi+=ebx
	ecx=edi and ecx,RN-1 jz >1
	dec ecx xor ecx,RN-1 edi+=ecx eax-=ecx
      # and eax,-RN ;round to RN
	mem\add_mem2()
      # ret

arg1=24h

#dos_int rm_int(21h) ret

#dpmi_rm_int
	pusha edi=rm_st esi=esp ecx=8 rep movsd
	edi=rm_st [edi+12]=ecx
	ax=300h bx=[esp+arg1]
	int 31h ;dpmi simulate real mode int
	esi=rm_st edi=esp ecx=8 rep movsd
	ah=[esi] sahf
	popa retp 4

#int_xx
	xchg eax,[esp] eax-=INTS imul eax,33h eax=ah ;calculate the interrupt number
	push eax call >1
	pop eax iret

#rm_int cmp d[mode_switch],0 jne dpmi_rm_int
      # push [esp] [esp+4]=cs jmp Rm_int,selector\code16

tmp_buffer_size=1000h
VDAT256 #tmp_buffer rb tmp_buffer_size
DAT256
#latin1
;;      bit 7 numero ,bit 6 letra, bit 5 minuscula,
	si bits 7-6=0 bits 0-5 indican numero de operando
	si bit 7=1 bits 0-3 numero
	bit 4 indica que puede ir combinado con otro codigo
;;      si bit 4=1 bit 0-3 tablas de combinaciones (ver \lib\keyb.asm)
db 34,0,0,0,0,0,0,0,0,32,34,0,0,34,0,0
db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
db 32,27,33,36,64,12,10,33,18,19,5,3,7,4,64,6
db 128,128+1,128+2,128+3,128+4,128+5,128+6,128+7,128+8,128+9,8,34,14,2,15,21
db 11,192+10,192+11,192+12,192+13,192+14,192+15,64,64,64,64,64,64,64,64,64
db 64,64,64,64,64,64,64,64,64,64,64,16,35,17,64+16+2,64
db 64+16,224+10,224+11,224+12,224+13,224+14,224+15,96,96,96,96,96,96,96,96,96
db 96,96,96,96,96,96,96,96,96,96,96,37,13,38,64+16+3,0
db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
db 0,64,64,64,64,64,64,64,64+16+4,64,64,64,64,64,64,64
db 64,64,64,64,64+16+1,64,64,64,64,64,64,64,64,64,64,20
db 64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
db 64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64
db 96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96
db 96,96,96,96,96,96,96,64,96,96,96,96,96,96,96,96


DAT4
#GDTR dw GDT_END-GDT_START-1 dd GDT_START
#IDT_real_mode          dw 1023 dd 0
#IDT_protected_mode     dw (IDT_END-IDT_START)-1 dd IDT_START

#GDT_START
dq 0                    ; null descriptor
dd 0FFFFh,9A00h         ; 16-bit code descriptor  ;8f9ah +granularity
dd 0FFFFh,0CF9A00h      ; 32-bit code descriptor
dd 0FFFFh,8F9200h       ; 32-bit data descriptor  ;0cf92h +big
#GDT_END
VDAT4 #IDT_START rb 100h*8 #IDT_END #INTS rb 100h*5


CODE
\LIB.ASM

#read     ;(f,bufer,nbytes)  eax,edi,ecx ncr retorna bytes leidos en ecx y cf si error
	pusha ebx=eax eax=ecx edx=tmp_buffer
      # ecx=tmp_buffer_size sub eax,ecx push eax jns >1
	ecx+=eax
      # ah=3fh dos_int() ecx=ax esi=edx
	movedata() cmp ax,tmp_buffer_size pop eax je <2
	sub edi,[esp] [esp+24]=edi
	popa ret

#lseek  ;eax=file edx=pos
	pusha ecx=[esp+22]
	ebx=eax ax=4200h dos_int()
	popa ret

#filesize  ;(int f) eax  retorna ecx:edx ncr
     pusha ebx=eax ax=4201h cx=0 dx=cx dos_int()
     push dx,ax ax=4202h cx=0 dx=cx dos_int()
     [esp+24]=ax [esp+26]=dx
     pop cx,dx ax=4200h dos_int()
     popa xor ecx,ecx ret

#write  ;(f,bufer,nbytes)  eax,edi,ecx ncr retorna bytes leidos en ecx y cf si error
	pusha ebx=eax edx=edi add edi,ecx shr edi,16 jnz >1
	ah=40h dos_int() [esp+24]=ax popa ret
      # esi=edx edx=tmp_buffer eax=ecx
      # ecx=tmp_buffer_size sub eax,ecx
	push eax jns >1
	add ecx,eax
      # push ecx edi=edx movedata()
	pop ecx ah=40h dos_int() cmp ax,tmp_buffer_size
	pop eax je <2
	sub edi,[esp] [esp+24]=edi
	popa ret

#trunclose pusha cx=0 bx=ax ah=40h dos_int() popa
#close pusha bx=ax ah=3eh dos_int() popa eax=0 ret

#get_file { ;(nombre,modo) esi,al retorno en eax ncr
	   ;actualiza esi y src_ptr
	pusha edx=esp sub esp,80h
	lodsw edi=esp
	esi=[ebp+directorio] [ebp+directorio+4]=esi
	test esi jz first
	cmp al,'\' je first
	cmp ah,':' je first
	ecx=[esi-4] esi+=4 ecx-=4 rep movsb
 #first esi=[edx+4] lodsb
    #l1 stosb lodsb cmp edi,edx jnc error\open
	cmp al,' ' ja l1
	b[edi]=0 dec esi [edx+4]=esi ecx=edi
	[ebp+src_ptr]=esi al=[edx+28] edx=esp
	push edi,ebp
	and eax,3 ah=3dh cmp al,3 jne >1
	al=2 dos_int() jnc >2
	ax=3c02h edx=esp+8 ecx=0
      # dos_int() jc error\open
      # pop edi,ebp [esp+28+80h]=eax
   #l2  dec edi cmp edi,esp jc l4
	al=b[edi]
	cmp al,'\' je l3
	cmp al,':' jne l2
   #l3  sub edi,esp ecx=edi+5 malloc()
	[ebp+directorio+4]=edi d[edi]=[ebp+dir_lst]
	[ebp+dir_lst]=edi
	edi+=4 ecx-=4 esi=esp movedata()
   #l4  esp+=80h
	popad
	ret
      }

