/*	EVAR.H: Environment and user variable definitions
		for MicroEMACS

		written 1993 by Daniel Lawrence
*/

#define MAXVARS 	512	/* Maximum number of global user variables */

/*	list of recognized environment variables	*/

NOSHARE char *envars[] = {
	"abbell",		/* ring bell on abbreviation expansion? */
	"abcap",		/* match capitolization in expansions */
	"abquick",		/* quick, aggressive expansions enabled? */
	"acount",		/* # of chars until next auto-save */
	"asave",		/* # of chars between auto-saves */
	"bufhook",		/* enter buffer switch hook */
	"cbflags",		/* current buffer flags */
	"cbufname",		/* current buffer name */
	"cfname",		/* current file name */
	"cmdhook",		/* command loop hook */
	"cmode",		/* mode of current buffer */
	"curchar",		/* current character under the cursor */
	"curcol",		/* current column pos of cursor */
	"curline",		/* current line in file */
	"curwidth",		/* current screen width */
	"curwind",		/* current window ordinal on current screen */
	"cwline",		/* current screen line in window */
	"debug",		/* macro debugging */
	"deskcolor",		/* desktop color */
	"diagflag",		/* diagonal mouse movements enabled? */
	"discmd",		/* display commands on command line */
	"disinp",		/* display command line input characters */
	"disphigh",		/* display high bit characters escaped */
	"dispundo",		/* display undo depth on command line */
	"exbhook",		/* exit buffer switch hook */
	"exithook",		/* exiting emacs hook */
	"fcol",			/* first displayed column in curent window */
	"fillcol",		/* current fill column */
	"flicker",		/* flicker supression */
	"fmtlead",		/* format command lead characters */
	"gflags",		/* global internal emacs flags */
	"gmode",		/* global modes */
	"hardtab",		/* current hard tab size */
	"hilight",		/* region # to hilight (255 to turn off) */
	"hjump",		/* horizontal screen jump size */
	"hscrlbar",		/* horizontal scroll bar flag */
	"hscroll",		/* horizontal scrolling flag */
	"isterm",		/* incremental-search terminator character */
	"kill", 		/* kill buffer (read only) */
	"language",		/* language of text messages */
	"lastkey",		/* last keyboard char struck */
	"lastmesg",		/* last string mlwrite()ed */
	"line", 		/* text of current line */
	"lterm",		/* current line terminator for writes */
	"lwidth",		/* width of current line */
	"match",		/* last matched magic pattern */
	"mmove",		/* mouse moves events style */
	"modeflag",		/* Modelines displayed flag */
	"msflag",		/* activate mouse? */
	"newscreen",		/* new screen with new buffer? */
	"numwind",		/* number of windows on current screen */
	"orgcol",		/* screen origin column */
	"orgrow",		/* screen origin row */
	"os",			/* what Operating System? */
	"overlap",		/* line overlap when paging */
	"pagelen",		/* number of lines used by editor */
	"palette",		/* current palette string */
	"paralead",		/* paragraph leadin characters */
	"pending",		/* type ahead pending flag */
	"popflag",		/* pop-up windows active? */
	"posflag",		/* display point position on modeline? */
	"progname",		/* returns current prog name - "MicroEMACS" */
	"ram",			/* ram in use by malloc */
	"readhook",		/* read file execution hook */
	"region",		/* current region (read only) */
	"replace",		/* replacement pattern */
	"rval", 		/* child process return value */
	"scrname",		/* current screen name */
	"search",		/* search pattern */
	"searchpnt",		/* differing search styles (term point) */
	"seed", 		/* current random number seed */
	"softtab",		/* current soft tab size */
	"sres", 		/* current screen resolution */
	"ssave",		/* safe save flag */
	"sscroll",		/* smooth scrolling flag */
	"status",		/* returns the status of the last command */
	"sterm",		/* search terminator character */
	"target",		/* target for line moves */
	"time",			/* date and time */
	"timeflag",		/* display time? */
	"tpause",		/* length to pause for paren matching */
	"undoflag",		/* currently processing undos */
	"version",		/* current version number */
	"vscrlbar",		/* vertical scroll bar flag */
	"wchars",		/* set of characters legal in words */
	"wline",		/* # of lines in current window */
	"wraphook",		/* wrap word execution hook */
	"writehook",		/* write file hook */
	"xpos", 		/* current mouse X position */
	"yankflag",		/* point placement at yanked/included text */
	"ypos"	 		/* current mouse Y position */
};

#define NEVARS	sizeof(envars) / sizeof(char *)

/*	and its preprocesor definitions 	*/

#define	EVABBELL	0
#define	EVABCAP		1
#define	EVABQUICK	2
#define EVACOUNT	3
#define EVASAVE 	4
#define	EVBUFHOOK	5
#define EVCBFLAGS	6
#define EVCBUFNAME	7
#define EVCFNAME	8
#define EVCMDHK 	9
#define EVCMODE 	10
#define EVCURCHAR	11
#define EVCURCOL	12
#define EVCURLINE	13
#define EVCURWIDTH	14
#define	EVCURWIND	15
#define EVCWLINE	16
#define EVDEBUG         17
#define	EVDESKCLR	18
#define EVDIAGFLAG      19
#define EVDISCMD        20
#define EVDISINP        21
#define	EVDISPHIGH	22
#define	EVDISPUNDO	23
#define EVEXBHOOK       24
#define	EVEXITHOOK	25
#define EVFCOL		26
#define EVFILLCOL	27
#define EVFLICKER	28
#define	EVFMTLEAD	29
#define EVGFLAGS	30
#define EVGMODE 	31
#define	EVHARDTAB	32
#define	EVHILITE	33
#define EVHJUMP		34
#define EVHSCRLBAR      35
#define EVHSCROLL	36
#define EVISTERM	37
#define EVKILL          38
#define EVLANG          39
#define EVLASTKEY       40
#define EVLASTMESG      41
#define EVLINE          42
#define	EVLTERM		43
#define EVLWIDTH        44
#define EVMATCH         45
#define EVMMOVE		46
#define EVMODEFLAG      47
#define EVMSFLAG        48
#define EVNEWSCRN	49
#define	EVNUMWIND	50
#define	EVORGCOL	51
#define	EVORGROW	52
#define	EVOS		53
#define	EVOVERLAP	54
#define EVPAGELEN       55
#define EVPALETTE       56
#define	EVPARALEAD	57
#define EVPENDING       58
#define	EVPOPFLAG	59
#define	EVPOSFLAG	60
#define EVPROGNAME      61
#define EVRAM           62
#define EVREADHK        63
#define	EVREGION	64
#define EVREPLACE       65
#define EVRVAL          66
#define EVSCRNAME	67
#define EVSEARCH        68
#define EVSEARCHPNT	69
#define EVSEED          70
#define EVSOFTTAB	71
#define EVSRES          72
#define EVSSAVE         73
#define EVSSCROLL	74
#define EVSTATUS	75
#define EVSTERM 	76
#define EVTARGET	77
#define EVTIME		78
#define EVTIMEFLAG	79
#define EVTPAUSE	80
#define	EVUNDOFLAG	81
#define EVVERSION	82
#define EVVSCRLBAR      83
#define	EVWCHARS	84
#define EVWLINE 	85
#define EVWRAPHK	86
#define	EVWRITEHK	87
#define EVXPOS		88
#define	EVYANKFLAG	89
#define EVYPOS		90

/*	list of recognized user functions	*/

typedef struct UFUNC {
	char *f_name;  /* name of function */
	int f_type;	/* 1 = monamic, 2 = dynamic */
} UFUNC;

#define NILNAMIC	0
#define MONAMIC 	1
#define DYNAMIC 	2
#define TRINAMIC	3

NOSHARE UFUNC funcs[] = {
	"abb", MONAMIC,		/* look up abbreviation */
	"abs", MONAMIC, 	/* absolute value of a number */
	"add", DYNAMIC,		/* add two numbers together */
	"and", DYNAMIC, 	/* logical and */
	"asc", MONAMIC, 	/* char to integer conversion */
	"ban", DYNAMIC, 	/* bitwise and	 9-10-87  jwm */
	"bin", MONAMIC, 	/* loopup what function name is bound to a key */
	"bno", MONAMIC, 	/* bitwise not */
	"bor", DYNAMIC, 	/* bitwise or	 9-10-87  jwm */
	"bxo", DYNAMIC, 	/* bitwise xor	 9-10-87  jwm */
	"cal", MONAMIC,		/* call a procedure */
	"cat", DYNAMIC, 	/* concatinate string */
	"chr", MONAMIC, 	/* integer to char conversion */
	"div", DYNAMIC, 	/* division */
	"env", MONAMIC, 	/* retrieve a system environment var */
	"equ", DYNAMIC, 	/* logical equality check */
	"exi", MONAMIC, 	/* check if a file exists */
	"fin", MONAMIC, 	/* look for a file on the path... */
	"gre", DYNAMIC, 	/* logical greater than */
	"gro", MONAMIC,		/* return group match in MAGIC mode */
	"gtc", NILNAMIC,	/* get 1 emacs command */
	"gtk", NILNAMIC,	/* get 1 charater */
	"ind", MONAMIC, 	/* evaluate indirect value */
	"isn", MONAMIC,		/* is the arg a number? */
	"lef", DYNAMIC, 	/* left string(string, len) */
	"len", MONAMIC, 	/* string length */
	"les", DYNAMIC, 	/* logical less than */
	"low", MONAMIC, 	/* lower case string */
	"mid", TRINAMIC,	/* mid string(string, pos, len) */
	"mod", DYNAMIC, 	/* mod */
	"neg", MONAMIC, 	/* negate */
	"not", MONAMIC, 	/* logical not */
	"or",  DYNAMIC, 	/* logical or */
	"rev", MONAMIC,		/* reverse */
	"rig", DYNAMIC, 	/* right string(string, pos) */
	"rnd", MONAMIC, 	/* get a random number */
	"seq", DYNAMIC, 	/* string logical equality check */
	"sgr", DYNAMIC, 	/* string logical greater than */
	"sin", DYNAMIC, 	/* find the index of one string in another */
	"sle", DYNAMIC, 	/* string logical less than */
	"slo", DYNAMIC,		/* set lower to upper char translation */
	"sub", DYNAMIC, 	/* subtraction */
	"sup", DYNAMIC,		/* set upper to lower char translation */
	"tim", DYNAMIC, 	/* multiplication */
	"tri", MONAMIC,		/* trim whitespace off the end of a string */
	"tru", MONAMIC, 	/* Truth of the universe logical test */
	"upp", MONAMIC, 	/* uppercase string */
	"xla", TRINAMIC		/* XLATE character string translation */
};

#define NFUNCS	sizeof(funcs) / sizeof(UFUNC)

/*	and its preprocesor definitions 	*/

#define	UFABBREV	0
#define UFABS		1
#define UFADD		2
#define UFAND		3
#define UFASCII 	4
#define UFBAND		5
#define UFBIND		6
#define UFBNOT		7
#define UFBOR		8
#define UFBXOR		9
#define	UFCALL		10
#define UFCAT		11
#define UFCHR		12
#define UFDIV		13
#define UFENV		14
#define UFEQUAL 	15
#define UFEXIST 	16
#define UFFIND		17
#define UFGREATER	18
#define UFGROUP		19
#define UFGTCMD 	20
#define UFGTKEY 	21
#define UFIND		22
#define	UFISNUM		23
#define UFLEFT		24
#define UFLENGTH	25
#define UFLESS		26
#define UFLOWER 	27
#define UFMID		28
#define UFMOD		29
#define UFNEG		30
#define UFNOT		31
#define UFOR		32
#define UFREVERSE	33
#define UFRIGHT 	34
#define UFRND		35
#define UFSEQUAL	36
#define UFSGREAT	37
#define UFSINDEX	38
#define UFSLESS 	39
#define	UFSLOWER	40
#define UFSUB		41
#define	UFSUPPER	42
#define UFTIMES 	43
#define	UFTRIM		44
#define UFTRUTH 	45
#define UFUPPER 	46
#define UFXLATE 	47
