
; MYMPLAY - Player for MYM-tunes
; MSX-version by Marq/Lieves!Tuore & Fit 30.1.2000
:
; 1.2.2000  - Added the disk loader. Thanks to Yzi & Plaque for examples.
; 7.2.2000  - Removed one unpack window -> freed 1.7kB memory
;
; Source suitable for Table-driven assembler (TASM), sorry all
; Devpac freaks :v/
;
; 3/2/2000 - Ported by AndyC <AndyCadley@bigfoot.com>
; 7/2/2000 - Upgraded to v0.4, optimized play routine,
;            added key scan and disk loader
;
;        CPC Port
;
; Notes:
;        AY Ports on CPC are accessed through the 8255 PPI
;        which is a right royal pain up the arse! :-)
;
;        0F4xxh is the data to be written
;        0F6xxh is the control signal dependent on bits 7 & 6
;        11 = Select register from data
;        10 = Write data to selected register
;        00 = Put PSG back into 'inactive' state after values have been 
;             written (v. important)
;
;        The player routine makes no effort to preserve the status of AY Port A
;        which is a bit of a bugger because it controls the CPCs keyboard.

;        Source is still in TASM format (sorry Maxam fans) 

; A macro definition of one of the undocumented Z80 opcodes which does OUT (C),0
; incredibly useful in all sorts of places
#define OUT_ZERO .db 0edh\.db 071h

PSG_SELECT	   .equ    0F6C0h	;CPC specific
PSG_WRITE	   .equ    0F680h	;CPC specific
PSG_INACTIVE   .equ    0F600h	;CPC specific
SPEED          .equ    6      ;CPC specific, number of ints in frame
CAS_IN_OPEN    .equ    0bc77h ;CPC specific - Firmware Routine
CAS_IN_DIRECT  .equ    0bc83h ;CPC specific - Firmware Routine
CAS_IN_CLOSE   .equ    0bc7ah ;CPC specific - Firmware Routine
TXT_OUTPUT     .equ    0bb5ah ;CPC specific - Firmware Routine

FRAG    .equ    128     ; Fragment size
REGS    .equ    14      ; Number of PSG registers
FBITS   .equ    7       ; Bits needed to store fragment offset

.org    1000h;	Aim reasonably low so we can play *big* tunes :-)

main:   call    readfile
        jr      c,loadok
        ret

loadok: call    showinfo        ; Print a message

        di		; CPC OS uses the alternate registers, so we shut it down
        exx                  
; First we need to preserve all the alternate registers so that we can return
; to basic when we've finished
        ex      af,af'
        push    af
        ex      af,af'
        push    bc
        push    de
        push    hl

   
        ld      e,1             ; Starting values for procedure readbits
        ld      d,0
        ld      hl,data
        exx        

        ld      hl,uncomp+FRAG  ; Starting values for the playing variables
        ld      (dest1),hl
        ld      (dest2),hl
        ld      (psource),hl
        ld      a,FRAG
        ld      (played),a
        ld      hl,0
        ld      (prows),hl

        call    extract         ; Unpack the first fragment
        call    setint

mainloop:
        call    extract

waitvb: ld      a,(played)      ; Wait until VBI has played a fragment
        or      a
        jr      nz,waitvb

        ld      (psource),iy
        ld      a,FRAG
        ld      (played),a

        call    keypress        ; End if key pressed
        jr      nz,mainloop

;Clean up, first by restoring alternate registers
        pop     hl
        pop     de
        pop     bc
        pop     af
        ex      af,af'
        exx
        
        call    restoreint
        call    shutup

        ret                     ; Goodbye!

; *** Unpack a fragment. Returns IY=new playing position for VBI
extract:
        ld      a,0
regloop:
        push    af
        ld      c,a
        ld      b,0
        ld      hl,regbits      ; D=Bits in this PSG register
        add     hl,bc
        ld      d,(hl)
        ld      hl,current      ; E=Current value of a PSG register
        add     hl,bc
        ld      e,(hl)

        ld      bc,FRAG*3
        ld      hl,(dest1)      ; IX=Destination 1
        ld      ix,(dest1)
        add     hl,bc
        ld      (dest1),hl
        ld      hl,(dest2)      ; HL=Destination 2
        push    hl
        add     hl,bc
        ld      (dest2),hl
        pop     hl

        ex      af,af'
        ld      a,FRAG          ; AF'=fragment end counter
        ex      af,af'
        ld      a,1             ; Get fragment bit
        call    readbits
        or      a
        jr      nz,compfrag     ; 1=Compressed fragment, 0=Unchanged

        ld      b,FRAG          ; Unchanged fragment: just set all to E
sweep:  ld      (hl),e
        inc     hl
        ld      (ix),e
        inc     ix
        djnz    sweep
        jp      nextreg

compfrag:                       ; Compressed fragment
        ld      a,1
        call    readbits
        or      a
        jr      nz,notprev      ; 0=Previous register value, 1=raw/compressed

        ld      (hl),e          ; Unchanged register
        inc     hl
        ld      (ix),e
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

notprev:
        ld      a,1
        call    readbits
        or      a
        jr      z,packed        ; 0=compressed data, 1=raw data

        ld      a,d             ; Raw data, read regbits[i] bits
        call    readbits
        ld      e,a
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        jp      nextbit

packed: ld      a,FBITS         ; Reference to previous data:
        call    readbits        ; Read the offset
        ld      c,a
        ld      a,FBITS         ; Read the number of bytes
        call    readbits
        ld      b,a

        push    hl
        push    bc
        ld      bc,-FRAG
        add     hl,bc
        pop     bc
        ld      a,b
        ld      b,0
        add     hl,bc
        ld      b,a
        push    hl
        pop     iy              ; IY=source address
        pop     hl

        inc     b
copy:   ld      a,(iy)          ; Copy from previous data
        inc     iy
        ld      e,a             ; Set current value
        ld      (hl),a
        inc     hl
        ld      (ix),a
        inc     ix
        ex      af,af'
        dec     a
        ex      af,af'
        djnz    copy

nextbit:
        ex      af,af'          ; If AF'=0 then fragment is done
        ld      c,a
        ex      af,af'
        ld      a,c
        or      a
        jp      nz,compfrag

nextreg:
        pop     af
        ld      b,0             ; Save the current value of PSG reg
        ld      c,a
        push    hl
        ld      hl,current
        add     hl,bc
        ld      (hl),e
        pop     hl

        inc     a               ; Check if all registers are done
        cp      REGS
        jp      nz,regloop

        or      a               ; Check if dest2 must be wrapped
        ld      bc,rows
        sbc     hl,bc
        jr      nz,nowrap

        ld      ix,FRAG+uncomp
        ld      hl,FRAG+uncomp
        ld      iy,(2*FRAG)+uncomp
        jr      endext

nowrap: ld      ix,uncomp
        ld      hl,(2*FRAG)+uncomp
        ld      iy,(FRAG)+uncomp

endext: ld      (dest1),ix
        ld      (dest2),hl

        ld      bc,FRAG         ; Check end-of-file. Clumsy :v/
        ld      hl,(prows)
        add     hl,bc
        ld      (prows),hl
        ld      bc,(rows)
        or      a
        sbc     hl,bc
        jr      c,noend         ; If rows>played rows then exit
        exx                     ; Otherwise restart
        ld      e,1
        ld      d,0
        ld      hl,data
        exx
        ld      hl,0
        ld      (prows),hl

noend:  ret

; *** Reads A bits from data, returns bits in A
readbits:
        exx
        ld      b,a
        ld      c,0

onebit: sla     c               ; Get one bit at a time
        rrc     e
        jr      nc,nonew        ; Wrap the AND value
        ld      d,(hl)
        inc     hl

nonew:  ld      a,e
        and     d
        jr      z,zero
        inc     c
zero:   djnz    onebit

        ld      a,c
        exx
        ret

; *** The interrupt handler. CPC specific
interrupt:
        push    af
        push    bc
        push    de
        push    hl

; CPC interrupts occur every 300th of a second so we need
; to ignore some of them.

        ld      a,(int_count)
        dec     a
        ld      (int_count),a
        jp      nz,endint
        ld      a,SPEED
        ld      (int_count),a

        ld      hl,(psource)
        ld      de,(3*FRAG)-1; Bytes to skip before next reg-1

;Output all registers
        xor     a;	a is register to write to
ploop:  ld      b,0F4h
        out     (c),a;	put register on PPI data
        ld      bc,PSG_SELECT
        out     (c),c
        OUT_ZERO;	PSG = Inactive

        ld      b,0F4h
        ld      c,(hl);	put output byte on PPI data
        out     (c),c
        ld      bc,PSG_WRITE
        out     (c),c
        OUT_ZERO;	PSG = Inactive
        inc     hl

        inc     a
        add     hl,de
        cp      REGS-1
        jp      nz,ploop

	
        ld      a,(hl)
        inc     a       ;if reg 13=255 skip
        jr      z,notrig
        dec     a;	Put back the right value

        ld      bc,0F40Dh;	Reg Select 13
        out     (c),c
        ld      bc,PSG_SELECT
        out     (c),c
        OUT_ZERO;	PSG = Inactive

        ld     b,0F4h
        out    (c),a
        ld     bc,PSG_WRITE
        out    (c),c
        OUT_ZERO;	PSG = Inactive

;*/CPC specific section*

notrig: ld      hl,(psource)
        inc     hl
        ld      (psource),hl

        ld      a,(played)
        or      a
        jr      z,endint
        dec     a
        ld      (played),a

endint: pop     hl
        pop     de
        pop     bc
        pop     af
        ei
        ret

; *** Sets a new interrupt handler. CPC-specific
setint:
        di
        ld      hl,38h
        ld      de,oldint
        ldi
        ldi
        ldi
        ld      a,0c3h
        ld      (038h),a
        ld      hl,interrupt
        ld      (038h+1),hl
        ei
        ret

restoreint:
        di
        ld      hl,oldint
        ld      de,38h
        ldi
        ldi
        ldi
        ei
        ret

; *** Reads a file given as a parameter, eg. CALL &1000,"file.mym".
;     CPC specific
readfile:
        cp      1
        jp     nz,loadfail;   Return if no parameter is supplied

        ld      l,(ix+0)
        ld      h,(ix+1)
        ld      b,(hl);  B = length of filename
        inc     hl
        ld      a,(hl)
        inc     hl
        ld      h,(hl)
        ld      l,a;  HL = ptr to filename

        ld      de,0c000h; AFAIK this buffer isn't actually used by CAS_IN_DIRECT but
                         ; we'll put in somewhere safe (the screen) anyway

        call    CAS_IN_OPEN
        ret     nc;   I hope I've got this the right way round

        ld      hl,rows;        Address to load file to
        call    CAS_IN_DIRECT
        ret     nc
        call    CAS_IN_CLOSE
        ret     nc

        scf              ; Success!!!
        ret

loadfail:
        and a
        ret
	
; *** Print an info string. CPC specific
showinfo:
        ld      hl,info
showloop:
        ld      a,(hl)
        and     a
        ret     z
        inc     hl
        call    TXT_OUTPUT
        djnz    showloop
        ret

; *** Shuts down the audio. CPC specific
shutup:
        ld      e,14
        ld      a,0
shloop:
        ld      b,0F4h
        out     (c),a
        ld      bc,PSG_SELECT
        out     (c),c
        OUT_ZERO;	PSG = Inactive
        inc     a

        ld     bc,0F400h
        out    (c),c
        ld     bc,PSG_WRITE
        out    (c),c
        OUT_ZERO;	PSG = Inactive

        dec    e
        jr     nz,shloop
        ret

; *** Keypress. CPC-specific
keypress:

        di
        ld     bc,0f40eh
        out    (c),c
        ld     bc,0f6c0h
        out    (c),c
        OUT_ZERO
        ld     bc,0f792h
        out    (c),c
        ld     bc,0f648h
        out    (c),c
        ld     b,0f4h
        in     a,(c)
        ld     b,0f6h
        OUT_ZERO
        ld     bc,0f782h
        out    (c),c
        bit    2,a
        ei
        ret

; *** Program data
oldint: .dw     0       ; Old int handler
        .db     0       ;    CPC specific, we need an extra byte to store the interrupt
int_count: .db  5       ; Interrupt Counter CPC specific
played: .db     0       ; VBI counter
dest1:  .dw     0       ; Uncompress destination 1
dest2:  .dw     0       ; - " -                  2
psource: .dw    0       ; Playing offset for the VB-player
prows:  .dw     0       ; Rows played so far

info    .db     "MYM player 0.4 "
        .db     "by Marq/Lieves!Tuore",13,10
        .db     "CPC Port by AndyC",13,10
        .db     "Press Esc to exit...",13,10,0

; Bits per PSG register
regbits: .db    8,4,8,4,8,4,5,8,5,5,5,8,8,8
; Current values of PSG registers
current: .db    0,0,0,0,0,0,0,0,0,0,0,0,0,0

; Reserve room for uncompressed data
uncomp:
.org $+(3*FRAG*REGS)

; The tune is stored here
rows:   .dw     0
data:

.end
