/* Amstrad CPC screen saver relocation generator */
/* Mark RISON, mrison@hotmail.com, 1999-06-19 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define NUL 0

typedef unsigned short word;

int main (void)
{
	char buf[256];
	word patchaddr, patchvalue;
	int line = 200;

	while (gets(buf) != NULL)
	{
		if (strstr (buf, "ABS") != NULL)
		{
			if (buf[18] == ' ' || buf[18] == '\t')
			{
				patchaddr = strtoul (&buf[6], NULL, 16) + 1;
				patchvalue = strtoul (&buf[14], NULL, 16);
			}
			else
			{
				patchaddr = strtoul (&buf[6], NULL, 16) + 2;
				patchvalue = strtoul (&buf[16], NULL, 16);
			}
			patchvalue = patchvalue >> 8 |
				((patchvalue & 0xff) << 8);
			printf ("%i a = &%x + d : v = &%x + d : GOSUB 666\n",
				line, patchaddr, patchvalue);
			line += 10;
		}
	}
}
