	ORG	#A000
	RUN	#A000

	LD	DE,#C000 ; pour test en basic
	LD	IX,#4000 ; pour test en basic
;
; Entre :
;
;   IX = Buffer (fichier compact)
;   DE = Destination
;
; Sortie :
;
;   AF, BC, DE, HL et IX modifis
;
;
DEPACT: XOR     A
        LD      (DEPACKBITS),A
BOUCLE:
        LD      A,(DEPACKBITS)
        LD      B,A
        RRA
        LD      (DEPACKBITS),A
        AND     A
        JR      NZ,TESTBIT
;
        LD      A,(IX+0)
        INC     IX
        LD      B,A
        RRA
        OR      #80
        LD      (DEPACKBITS),A
TESTBIT:
        LD      A,B
        AND     1
        JR      NZ,TESTCODE

        LD      A,(IX+0)
        INC     IX
        LD      (DE),A
        INC     DE
        JR      BOUCLE
;
TESTCODE:
        LD      A,(IX+0)
        AND     A
;
; Plus d'octets  traiter
; = fini
;
        RET     Z

        LD      B,A
TEST80:
        AND     #80
        JR      Z,TEST40
;
        LD      A,B
        LD      C,A
        RRCA
        RRCA
        RRCA
        RRCA
        AND     7
        ADD     A,3
        LD      B,A
        LD      A,C
        INC     IX
        AND     #0F
        LD      H,A
        LD      C,B
        LD      B,0
        LD      L,(IX+0)
        INC     IX
        INC     HL
        JR      COPIEINDEX
;
TEST40:
        LD      A,B
        AND     #40
        JR      Z,TEST20
;
        LD      A,B
        AND     #3F
        LD      L,A
        LD      H,0
        INC     HL
        INC     IX
        LD      BC,2
        JR      COPIEINDEX
;
TEST20:
        LD      A,B
        AND     #20
        JR      Z,TEST10
;
        LD      A,B
        AND     #1F
        ADD     A,2
        LD      C,A
        INC     IX
        LD      L,(IX+0)
        LD      H,0
        LD      B,H
        INC     IX
        INC     HL
        JR      COPIEINDEX
;
TEST10:
        LD      A,B
        AND     #10
        JR      Z,CODE00
;
        LD      A,B
        AND     #0F
        LD      H,A
        INC     IX
        LD      L,(IX+0)
        INC     IX
        LD      C,(IX+0)
        LD      B,0
        INC     IX
        INC     BC
        INC     HL
        JR      COPIEINDEX
;
CODE00:
        LD      A,B
        CP      15
        JR      NZ,CODEN15
;
        INC     IX
        LD      C,(IX+0)
        LD      B,0
        INC     BC
        PUSH    BC
        POP     HL
        INC     IX
        JR      COPIEINDEX
;
CODEN15:
        CP      2
        JR      C,CODEINF2
;
        LD      C,A
        LD      L,A
        LD      H,0
        LD      B,H
        INC     IX
        JR      COPIEINDEX
;
CODEINF2:
        LD      BC,#100
        PUSH    BC
        POP     HL
        INC     IX
;
; Routine de copie d'octets :
;
;       HL = index
;       BC = length
;       (DE = dest)
;
COPIEINDEX:
        XOR     A
        PUSH    DE
        EX      DE,HL
        SBC     HL,DE
        POP     DE
        LDIR
        JP      BOUCLE
;
DEPACKBITS:
    DEFB    0
