#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define SEEKBACK 4096
#define MAXSTRING 256

static int matches[ 256 ];
static int matchtable[ 256 ][ SEEKBACK ];


int main( int argc, char **argv )
{
    FILE *in;
    FILE *out;
    unsigned char codebuffer[ 24 ];
    unsigned char bits;
    int count, bitcount, codecount;
    int length, packlength;
    int matchtablestart = 0, matchtableend = 0, oldmatchtablestart;
    int c;
    unsigned char *inbuffer;

    if ( argc < 3 )
        {
        printf( "Usage: cpack <in> <out>\n" );
        return 1;
        }
    in = fopen( argv[ 1 ], "rb" );
    if ( ! in )
        {
        printf( "Can't open source!\n" );
        return 0;
        }

    fseek( in, 0, SEEK_END );
    length = ftell( in );
    fseek( in, 0, SEEK_SET );

    inbuffer = malloc( length );
    if ( ! inbuffer )
        {
        printf( "Out of memory!\n" );
        return 1;
        }
    fread( inbuffer, length, 1, in );
    fclose( in );

    out = fopen( argv[ 2 ], "wb" );
    if ( !out )
        {
        printf( "Can't open destination!\n" );
        return 1;
        }

    packlength = 0;
    bitcount = 0;
    codecount = 0;
    bits = 0;
    count = 0;
    memset( matches, 0, sizeof( matches ) );
    for( ;; )
        {
        for ( c = matchtableend; c < count; c++ )
            {
            int b = inbuffer[ c ];

            matchtable[ b ][ matches[ b ] ] = c;
            matches[ b ]++;
            }
        matchtableend = count;

        if ( count >= 2 )
            {
            int stlen = 0;
            int stpos = 0;
            int stlen2 = 0;
            int bb = inbuffer[ count ];

            for ( c = matches[ bb ]-1; c >= 0; c-- )
                {
                int start = matchtable[ bb ][ c ];
                int end = start + MAXSTRING;
                if ( end > count )
                    end = count;

                if ( end-start >= stlen )
                    {
                    int max = end - start;
                    int d;

                    for ( d = 1; d < max; d++ )
                        if ( inbuffer[ start+d ] != inbuffer[ count+d ] ) 
                            break;

                    if ( ( d >= 2 ) && ( d > stlen ) )
                        {
                        stlen = d;
                        stpos = count - start;
                        }
                    if ( ( d == stlen ) && ( count - start < stpos ) )
                        stpos = count - start;
                    }

                if ( ( stlen == MAXSTRING ) && ( stpos == stlen ) ) 
                    break;
                }

            if ( count+1 < length )
                {
                bb = inbuffer[ count+1 ];

                for ( c = matches[ bb ]-1; c >= 0; c-- )
                    {
                    int start = matchtable[ bb ][ c ];
                    int end = start + MAXSTRING;
                    if ( end > count+1 ) end = count+1;

                    if ( end-start >= stlen2 )
                        {
                        int max = end - start;
                        int d;

                        for ( d = 1; d < max; d++ )
                            if ( inbuffer[ start+d ] != inbuffer[ count+d+1 ] )
                                break;

                        if ( ( d >= 2 ) && ( d >= stlen2 ) )
                            stlen2 = d;
                        }
                    if ( stlen2 == MAXSTRING )
                        break;
                    }
                if ( stlen2-1 > stlen )
                    stlen = 0;
                }

            if ( stlen > 1 )
                {
                if ( ( stlen == 2 ) && ( stpos >= 256 ) )
                    goto LITERAL;

                if ( stpos == stlen )
                    {
                    if ( stlen == MAXSTRING )
                        codebuffer[ codecount++ ] = 0x1;
                    else
                        {
                        if ( stlen <= 14 )
                            codebuffer[ codecount++ ] = stlen;
                        else
                            {
                            codebuffer[ codecount++ ] = 0xf;
                            codebuffer[ codecount++ ] = stlen - 1;
                            }
                        }
                    }
                else
                    {
                    if ( ( stlen == 2 ) && ( stpos < 65 ) )
                        codebuffer[ codecount++ ] = 0x40 + stpos - 1;
                    else
                        {
                        if ( ( stlen <= 33 ) && ( stpos < 257 ) )
                            {
                            codebuffer[ codecount++ ] = 0x20 + stlen-2;
                            codebuffer[ codecount++ ] = stpos - 1;
                            }
                        else
                            {
                            if ( ( stlen >= 3 ) && ( stlen <= 10 ) )
                                {
                                codebuffer[ codecount++ ] = 0x80 + ( ( stlen - 3 ) << 4 ) + ( ( stpos-1 ) >> 8 );
                                codebuffer[ codecount++ ] = ( stpos-1 ) & 0xff;
                                }
                            else
                                {
                                codebuffer[ codecount++ ] = 0x10 + ( ( stpos-1 ) >> 8 );
                                codebuffer[ codecount++ ] = ( stpos-1 ) & 0xff;
                                codebuffer[ codecount++ ] = stlen-1;
                                }
                            }
                        }
                    }
                bits |= 1 << bitcount;
                bitcount++;
                count += stlen;
                }
            else
                {
                LITERAL:
                codebuffer[ codecount++ ] = inbuffer[ count++ ];
                bitcount++;
                }
            }
        else
            {
            codebuffer[ codecount++ ] = inbuffer[ count++ ];
            bitcount++;
            }
        if ( bitcount == 8 )
            {
            fputc( bits, out );
            fwrite( codebuffer, codecount, 1, out );
            packlength += 1 + codecount;
            fflush( stdout );
            bitcount = 0;
            codecount = 0;
            bits = 0;
            }
        if ( count >= length )
            break;

        oldmatchtablestart = matchtablestart;
        matchtablestart = count - SEEKBACK;
        if ( matchtablestart < 0 )
            matchtablestart = 0;

        for ( c = oldmatchtablestart; c < matchtablestart; c++ )
            {
            int b = inbuffer[ c ];
            int d;

            for ( d = 0; d < matches[ b ]; d++ )
                {
                if ( matchtable[ b ][ d ] >= matchtablestart )
                    {
                    memmove( &matchtable[ b ][ 0 ], &matchtable[ b ][ d ], ( matches[ b ]-d )*sizeof( int ) );
                    break;
                    }
                }
            matches[ b ] -= d;
            }
        }
    codebuffer[ codecount++ ] = 0;
    bits |= 1 << bitcount;
    if ( codecount )
        {
        fputc( bits, out );
        fwrite( codebuffer, codecount, 1, out );
        packlength += 1 + codecount;
        fflush( stdout );
        }
    fclose( out );
    free( inbuffer );
    return 0;
}

