#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#define MAXOUTPUT 0x200000


static int Depack( unsigned char * inbuffer
                 , unsigned char * outbuffer
                 )
{
    unsigned char a, depackbits = 0;
    int bit, inbytes = 0, length, index, outbytes = 0;

    for ( ;; )
        {
        bit = depackbits & 1;
        depackbits >>= 1;
        if ( !depackbits )
            {
            depackbits = inbuffer[ inbytes++ ];
            bit = depackbits & 1;
            depackbits >>= 1;
            depackbits |= 0x80;
            }
        if ( ! bit )
            outbuffer[ outbytes++ ] = inbuffer[ inbytes++ ];
        else
            {
            if ( !inbuffer[ inbytes ] )
                break; /* EOF */

            a = inbuffer[ inbytes ];
            if ( a & 0x80 )
                {
                length = 3 + ( ( inbuffer[ inbytes ] >> 4 ) & 7 );
                index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
                index |= inbuffer[ inbytes++ ];
                index++;
                }
            else
                if ( a & 0x40 )
                    {
                    length = 2;
                    index = inbuffer[ inbytes++ ] & 0x3f;
                    index++;
                    }
                else
                    if ( a & 0x20 )
                        {
                        length = 2 + ( inbuffer[ inbytes++ ] & 31 );
                        index = inbuffer[ inbytes++ ];
                        index++;
                        }
                    else
                        if ( a & 0x10 )
                            {
                            index = ( inbuffer[ inbytes++ ] & 15 ) << 8;
                            index |= inbuffer[ inbytes++ ];
                            length = inbuffer[ inbytes++ ] + 1;
                            index++;
                            }
                        else
                            {
                            if ( inbuffer[ inbytes ] == 15 )
                                {
                                length = index = inbuffer[ inbytes+1 ] + 1;
                                inbytes += 2;
                                }
                            else
                                {
                                if ( inbuffer[ inbytes ] > 1 )
                                    length = index = inbuffer[ inbytes ];
                                else
                                    length = index = 256;

                                inbytes++;
                                }
                            }
            for ( ; length--; )
                {
                outbuffer[ outbytes ] = outbuffer[ outbytes-index ];
                outbytes++;
                }
            }
        }
    return( outbytes );
}


int main( int argc, char **argv )
{
    static unsigned char inbuffer[ MAXOUTPUT ];
    static unsigned char outbuffer[ MAXOUTPUT ];
    int outbytes;

    FILE *in;
    FILE *out;
    int length;
    if ( argc < 3 )
        printf( "Usage: cdepack <in> <out>\n" );
    else
        {
        in = fopen( argv[ 1 ], "rb" );
        if ( in )
            {
            length = fread( inbuffer, 1, MAXOUTPUT, in );
            fclose( in );

            out = fopen( argv[ 2 ], "wb" );
            if ( out )
                {
                outbytes = Depack( inbuffer, outbuffer );
                fwrite( outbuffer, outbytes, 1, out );
                fclose( out );
                }
            }
        }
    return 0;
}
